//---------------------------------------------------------------------------

#ifndef Main_FormH
#define Main_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <FileCtrl.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <Buttons.hpp>
#include <vector.h>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
typedef enum {BC_INFO, BC_BACKUP, BC_RESTORE} EBackupCommand;
//---------------------------------------------------------------------------
typedef struct
{
    AnsiString Dir;
    TDateTime BackupTime;
    bool UserInfoExist;
    bool SystemInfoExist;
    bool ProductInfoExist;
    bool DefectImageExist;
    bool AuditTrail;
} TBackupInfoUnit;
//---------------------------------------------------------------------------
class TMainForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntLabel *Label1;
	TDriveComboBox *DriveComboBox;
	TTntLabel *Label2;
	TTntLabel *FreeDiscSpaceLabel;
	TTntPanel *BackupDataInfoPanel;
	TTntLabel *Label3;
    TTntStringGrid *BackupInfoStringGrid;
	TTntPanel *Panel4;
	TTntButton *DeleteBackupDataButton;
	TTntPanel *BackupPanel;
	TTntGroupBox *GroupBox1;
	TTntCheckBox *BCUserInfoCheckBox;
	TTntCheckBox *BCSystemInfoCheckBox;
	TTntCheckBox *BCProductInfoCheckBox;
	TTntCheckBox *BCDefectImageCheckBox;
	TTntSpeedButton *BackupSpeedButton;
	TTntSpeedButton *RestoreSpeedButton;
	TTntLabel *UserInfoDataSizeLabel;
	TTntLabel *SystemInfoDataSizeLabel;
	TTntLabel *ProductInfoDataSizeLabel;
	TTntLabel *Label7;
	TTntPanel *Panel2;
	TTntButton *BackupStartButton;
	TTntSpeedButton *BackupInfoSpeedButton;
    TTntPanel *RestorePanel;
    TTntLabel *Label8;
    TTntStringGrid *RestoreStringGrid;
    TTntGroupBox *GroupBox2;
    TTntCheckBox *RCUserInfoCheckBox;
    TTntCheckBox *RCSystemInfoCheckBox;
    TTntCheckBox *RCProductInfoCheckBox;
    TTntCheckBox *RCDefectImageCheckBox;
    TTntButton *RestoreButton;
	TTntCheckBox *IncludeTabletImageCheckBox;
  TTntCheckBox *BCAuditTrailCheckBox;
  TTntLabel *AuditTrailDataSizeLabel;
  TTntCheckBox *RCAuditTrailCheckBox;
  TTntSpeedButton *ExitButton;
	void __fastcall DriveComboBoxChange(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall BackupInfoSpeedButtonClick(TObject *Sender);
	void __fastcall BackupSpeedButtonClick(TObject *Sender);
	void __fastcall BackupStartButtonClick(TObject *Sender);
    void __fastcall RestoreSpeedButtonClick(TObject *Sender);
    void __fastcall RestoreButtonClick(TObject *Sender);
    void __fastcall RestoreStringGridSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
    void __fastcall ExitButton1Click(TObject *Sender);
	void __fastcall DeleteBackupDataButtonClick(TObject *Sender);
	void __fastcall BCProductInfoCheckBoxClick(TObject *Sender);
  void __fastcall ExitButtonClick(TObject *Sender);
private:	// User declarations
    vector<TBackupInfoUnit> BackupInfoList;
    EBackupCommand Command;
    void __fastcall RefreshBackupList(void);
    void __fastcall RefreshStringGrid(void);
    void __fastcall RefreshRestoreStringGrid(void);

    void __fastcall CalculateDataSize(void);
    __int64 __fastcall CalculateUserInfoDataSize(void);
    __int64 __fastcall CalculateSystemInfoDataSize(void);
    __int64 __fastcall CalculateProductInfoDataSize(void);
    __int64 __fastcall CalculateAuditTrailDataSize(void);

    __int64 __fastcall CalculateDirSize(AnsiString dir);
	AnsiString __fastcall GetDataSizeStr(__int64 dataSize);
	void __fastcall RemoveAll(AnsiString folder);
	void __fastcall RefreshBackupPanel(void);
    void __fastcall ReadBackupProgramOption();

  int DefaultLCID;

public:		// User declarations
	__fastcall TMainForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
